<?php

/**
 * All possible mime types
 */
return array(
	'123' => 'application/vnd.lotus-1-2-3',
	'3dml' => 'text/vnd.in3d.3dml',
	'3g2' => 'video/3gpp2',
	'3gp' => 'video/3gpp',
	'aab|x32|u32|vox' => 'application/x-authorware-bin',
	'aac' => 'audio/x-aac',
	'aam' => 'application/x-authorware-map',
	'aas' => 'application/x-authorware-seg',
	'abw' => 'application/x-abiword',
	'acc' => 'application/vnd.americandynamics.acc',
	'ace' => 'application/x-ace-compressed',
	'acu' => 'application/vnd.acucobol',
	'adp' => 'audio/adpcm',
	'aep' => 'application/vnd.audiograph',
	'afp|listafp|list3820' => 'application/vnd.ibm.modcap',
	'aif|aiff|aifc' => 'audio/x-aiff',
	'air' => 'application/vnd.adobe.air-application-installer-package+zip',
	'ai|eps|ps' => 'application/postscript',
	'ami' => 'application/vnd.amiga.ami',
	'apk' => 'application/vnd.android.package-archive',
	'application' => 'application/x-ms-application',
	'apr' => 'application/vnd.lotus-approach',
	'asc|sig' => 'application/pgp-signature',
	'asf|asx' => 'video/x-ms-asf',
	'aso' => 'application/vnd.accpac.simply.aso',
	'atc|acutc' => 'application/vnd.acucorp',
	'atom' => 'application/atom+xml',
	'atomcat' => 'application/atomcat+xml',
	'atomsvc' => 'application/atomsvc+xml',
	'atx' => 'application/vnd.antix.game-component',
	'au|snd' => 'audio/basic',
	'avi' => 'video/x-msvideo',
	'aw' => 'application/applixware',
	'azf' => 'application/vnd.airzip.filesecure.azf',
	'azs' => 'application/vnd.airzip.filesecure.azs',
	'azw' => 'application/vnd.amazon.ebook',
	'bcpio' => 'application/x-bcpio',
	'bdf' => 'application/x-font-bdf',
	'bdm' => 'application/vnd.syncml.dm+wbxml',
	'bh2' => 'application/vnd.fujitsu.oasysprs',
	'bin|dms|lha|lrf|lzh|so|iso|dmg|dist|distz|pkg|bpk|dump|elc|deploy' => 'application/octet-stream',
	'bmi' => 'application/vnd.bmi',
	'bmp' => 'image/bmp',
	'box' => 'application/vnd.previewsystems.box',
	'btif' => 'image/prs.btif',
	'bz' => 'application/x-bzip',
	'bz2|boz' => 'application/x-bzip2',
	'c4g|c4d|c4f|c4p|c4u' => 'application/vnd.clonk.c4group',
	'cab' => 'application/vnd.ms-cab-compressed',
	'car' => 'application/vnd.curl.car',
	'cat' => 'application/vnd.ms-pki.seccat',
	'ccxml' => 'application/ccxml+xml',
	'cdbcmsg' => 'application/vnd.contact.cmsg',
	'cdkey' => 'application/vnd.mediastation.cdkey',
	'cdx' => 'chemical/x-cdx',
	'cdxml' => 'application/vnd.chemdraw+xml',
	'cdy' => 'application/vnd.cinderella',
	'cer' => 'application/pkix-cert',
	'cgm' => 'image/cgm',
	'chat' => 'application/x-chat',
	'chm' => 'application/vnd.ms-htmlhelp',
	'chrt' => 'application/vnd.kde.kchart',
	'cif' => 'chemical/x-cif',
	'cii' => 'application/vnd.anser-web-certificate-issue-initiation',
	'cil' => 'application/vnd.ms-artgalry',
	'cla' => 'application/vnd.claymore',
	'class' => 'application/java-vm',
	'clkk' => 'application/vnd.crick.clicker.keyboard',
	'clkp' => 'application/vnd.crick.clicker.palette',
	'clkt' => 'application/vnd.crick.clicker.template',
	'clkw' => 'application/vnd.crick.clicker.wordbank',
	'clkx' => 'application/vnd.crick.clicker',
	'clp' => 'application/x-msclip',
	'cmc' => 'application/vnd.cosmocaller',
	'cmdf' => 'chemical/x-cmdf',
	'cml' => 'chemical/x-cml',
	'cmp' => 'application/vnd.yellowriver-custom-menu',
	'cmx' => 'image/x-cmx',
	'cod' => 'application/vnd.rim.cod',
	'cpio' => 'application/x-cpio',
	'cpt' => 'application/mac-compactpro',
	'crd' => 'application/x-mscardfile',
	'crl' => 'application/pkix-crl',
	'csh' => 'application/x-csh',
	'csml' => 'chemical/x-csml',
	'csp' => 'application/vnd.commonspace',
	'css' => 'text/css',
	'csv' => 'text/csv',
	'cu' => 'application/cu-seeme',
	'curl' => 'text/vnd.curl',
	'cww' => 'application/prs.cww',
	'c|cc|cxx|cpp|h|hh|dic' => 'text/x-c',
	'daf' => 'application/vnd.mobius.daf',
	'davmount' => 'application/davmount+xml',
	'dcurl' => 'text/vnd.curl.dcurl',
	'dd2' => 'application/vnd.oma.dd2+xml',
	'ddd' => 'application/vnd.fujixerox.ddd',
	'deb|udeb' => 'application/x-debian-package',
	'der|crt' => 'application/x-x509-ca-cert',
	'df' => 'application/x-deflate',
	'dfac' => 'application/vnd.dreamfactory',
	'dir|dcr|dxr|cst|cct|cxt|w3d|fgd|swa' => 'application/x-director',
	'dis' => 'application/vnd.mobius.dis',
	'djvu|djv' => 'image/vnd.djvu',
	'dna' => 'application/vnd.dna',
	'docm' => 'application/vnd.ms-word.document.macroenabled.12',
	'docx' => 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
	'doc|dot' => 'application/msword',
	'dotm' => 'application/vnd.ms-word.template.macroenabled.12',
	'dotx' => 'application/vnd.openxmlformats-officedocument.wordprocessingml.template',
	'dp' => 'application/vnd.osgi.dp',
	'dpg' => 'application/vnd.dpgraph',
	'dsc' => 'text/prs.lines.tag',
	'dtb' => 'application/x-dtbook+xml',
	'dtd' => 'application/xml-dtd',
	'dts' => 'audio/vnd.dts',
	'dtshd' => 'audio/vnd.dts.hd',
	'dvi' => 'application/x-dvi',
	'dwf' => 'model/vnd.dwf',
	'dwg' => 'image/vnd.dwg',
	'dxf' => 'image/vnd.dxf',
	'dxp' => 'application/vnd.spotfire.dxp',
	'ecelp4800' => 'audio/vnd.nuera.ecelp4800',
	'ecelp7470' => 'audio/vnd.nuera.ecelp7470',
	'ecelp9600' => 'audio/vnd.nuera.ecelp9600',
	'ecma' => 'application/ecmascript',
	'edm' => 'application/vnd.novadigm.edm',
	'edx' => 'application/vnd.novadigm.edx',
	'efif' => 'application/vnd.picsel',
	'ei6' => 'application/vnd.pg.osasli',
	'eml|all' => 'message/rfc822',
	'emma' => 'application/emma+xml',
	'eol' => 'audio/vnd.digital-winds',
	'eot' => 'application/vnd.ms-fontobject',
	'epub' => 'application/epub+zip',
	'es3|et3' => 'application/vnd.eszigno3+xml',
	'esf' => 'application/vnd.epson.esf',
	'etx' => 'text/x-setext',
	'exe|dll|com|bat|msi' => 'application/x-msdownload',
	'ext' => 'application/vnd.novadigm.ext',
	'ez' => 'application/andrew-inset',
	'ez2' => 'application/vnd.ezpix-album',
	'ez3' => 'application/vnd.ezpix-package',
	'f4v' => 'video/x-f4v',
	'fbs' => 'image/vnd.fastbidsheet',
	'fdf' => 'application/vnd.fdf',
	'fe_launch' => 'application/vnd.denovo.fcselayout-link',
	'fg5' => 'application/vnd.fujitsu.oasysgp',
	'fh|fhc|fh4|fh5|fh7' => 'image/x-freehand',
	'fig' => 'application/x-xfig',
	'fli' => 'video/x-fli',
	'flo' => 'application/vnd.micrografx.flo',
	'flv' => 'video/x-flv',
	'flw' => 'application/vnd.kde.kivio',
	'flx' => 'text/vnd.fmi.flexstor',
	'fly' => 'text/vnd.fly',
	'fm|frame|maker|book' => 'application/vnd.framemaker',
	'fnc' => 'application/vnd.frogans.fnc',
	'fpx' => 'image/vnd.fpx',
	'fsc' => 'application/vnd.fsc.weblaunch',
	'fst' => 'image/vnd.fst',
	'ftc' => 'application/vnd.fluxtime.clip',
	'fti' => 'application/vnd.anser-web-funds-transfer-initiation',
	'fvt' => 'video/vnd.fvt',
	'fzs' => 'application/vnd.fuzzysheet',
	'f|for|f77|f90' => 'text/x-fortran',
	'g3' => 'image/g3fax',
	'gac' => 'application/vnd.groove-account',
	'gdl' => 'model/vnd.gdl',
	'geo' => 'application/vnd.dynageo',
	'gex|gre' => 'application/vnd.geometry-explorer',
	'ggb' => 'application/vnd.geogebra.file',
	'ggt' => 'application/vnd.geogebra.tool',
	'ghf' => 'application/vnd.groove-help',
	'gif' => 'image/gif',
	'gim' => 'application/vnd.groove-identity-message',
	'gmx' => 'application/vnd.gmx',
	'gnumeric' => 'application/x-gnumeric',
	'gph' => 'application/vnd.flographit',
	'gqf|gqs' => 'application/vnd.grafeq',
	'gram' => 'application/srgs',
	'grv' => 'application/vnd.groove-injector',
	'grxml' => 'application/srgs+xml',
	'gsf' => 'application/x-font-ghostscript',
	'gtar' => 'application/x-gtar',
	'gtm' => 'application/vnd.groove-tool-message',
	'gtw' => 'model/vnd.gtw',
	'gv' => 'text/vnd.graphviz',
	'gz' => 'application/x-gzip',
	'h261' => 'video/h261',
	'h263' => 'video/h263',
	'h264' => 'video/h264',
	'hbci' => 'application/vnd.hbci',
	'hdf' => 'application/x-hdf',
	'hlp' => 'application/winhlp',
	'hpgl' => 'application/vnd.hp-hpgl',
	'hpid' => 'application/vnd.hp-hpid',
	'hps' => 'application/vnd.hp-hps',
	'hqx' => 'application/mac-binhex40',
	'htc' => 'text/x-component',
	'htke' => 'application/vnd.kenameaapp',
	'html|htm' => 'text/html',
	'hvd' => 'application/vnd.yamaha.hv-dic',
	'hvp' => 'application/vnd.yamaha.hv-voice',
	'hvs' => 'application/vnd.yamaha.hv-script',
	'icc|icm' => 'application/vnd.iccprofile',
	'ice' => 'x-conference/x-cooltalk',
	'ico' => 'image/x-icon',
	'ics|ifb' => 'text/calendar',
	'ief' => 'image/ief',
	'ifm' => 'application/vnd.shana.informed.formdata',
	'igl' => 'application/vnd.igloader',
	'igs|iges' => 'model/iges',
	'igx' => 'application/vnd.micrografx.igx',
	'iif' => 'application/vnd.shana.informed.interchange',
	'imp' => 'application/vnd.accpac.simply.imp',
	'ims' => 'application/vnd.ms-ims',
	'ipk' => 'application/vnd.shana.informed.package',
	'irm' => 'application/vnd.ibm.rights-management',
	'irp' => 'application/vnd.irepository.package+xml',
	'itp' => 'application/vnd.shana.informed.formtemplate',
	'ivp' => 'application/vnd.immervision-ivp',
	'ivu' => 'application/vnd.immervision-ivu',
	'jad' => 'text/vnd.sun.j2me.app-descriptor',
	'jam' => 'application/vnd.jam',
	'jar' => 'application/java-archive',
	'java' => 'text/x-java-source',
	'jisp' => 'application/vnd.jisp',
	'jlt' => 'application/vnd.hp-jlyt',
	'jnlp' => 'application/x-java-jnlp-file',
	'joda' => 'application/vnd.joost.joda-archive',
	'jpeg|jpg|jpe' => 'image/jpeg',
	'jpgv' => 'video/jpeg',
	'jpm|jpgm' => 'video/jpm',
	'js' => 'application/x-javascript',
	'json' => 'application/json',
	'karbon' => 'application/vnd.kde.karbon',
	'kfo' => 'application/vnd.kde.kformula',
	'kia' => 'application/vnd.kidspiration',
	'kml' => 'application/vnd.google-earth.kml+xml',
	'kmz' => 'application/vnd.google-earth.kmz',
	'kne|knp' => 'application/vnd.kinar',
	'kon' => 'application/vnd.kde.kontour',
	'kpr|kpt' => 'application/vnd.kde.kpresenter',
	'ksp' => 'application/vnd.kde.kspread',
	'ktz|ktr' => 'application/vnd.kahootz',
	'kwd|kwt' => 'application/vnd.kde.kword',
	'latex' => 'application/x-latex',
	'lbd' => 'application/vnd.llamagraphics.life-balance.desktop',
	'lbe' => 'application/vnd.llamagraphics.life-balance.exchange+xml',
	'les' => 'application/vnd.hhe.lesson-player',
	'less' => 'text/less',
	'link66' => 'application/vnd.route66.link66+xml',
	'lostxml' => 'application/lost+xml',
	'lrm' => 'application/vnd.ms-lrm',
	'ltf' => 'application/vnd.frogans.ltf',
	'lvp' => 'audio/vnd.lucent.voice',
	'lwp' => 'application/vnd.lotus-wordpro',
	'm3u' => 'audio/x-mpegurl',
	'm4v' => 'video/x-m4v',
	'mag' => 'application/vnd.ecowin.chart',
	'mathml' => 'application/mathml+xml',
	'ma|nb|mb' => 'application/mathematica',
	'mbk' => 'application/vnd.mobius.mbk',
	'mbox' => 'application/mbox',
	'mc1' => 'application/vnd.medcalcdata',
	'mcd' => 'application/vnd.mcd',
	'mcurl' => 'text/vnd.curl.mcurl',
	'mdb' => 'application/x-msaccess',
	'mdi' => 'image/vnd.ms-modi',
	'mfm' => 'application/vnd.mfmp',
	'mgz' => 'application/vnd.proteus.magazine',
	'mid|midi|kar|rmi' => 'audio/midi',
	'mif' => 'application/vnd.mif',
	'mj2|mjp2' => 'video/mj2',
	'mlp' => 'application/vnd.dolby.mlp',
	'mmd' => 'application/vnd.chipnuts.karaoke-mmd',
	'mmf' => 'application/vnd.smaf',
	'mmr' => 'image/vnd.fujixerox.edmics-mmr',
	'mny' => 'application/x-msmoney',
	'movie' => 'video/x-sgi-movie',
	'mp4a' => 'audio/mp4',
	'mp4s' => 'application/mp4',
	'mp4|mp4v|mpg4' => 'video/mp4',
	'mpc' => 'application/vnd.mophun.certificate',
	'mpeg|mpg|mpe|m1v|m2v' => 'video/mpeg',
	'mpga|mp2|mp2a|mp3|m2a|m3a' => 'audio/mpeg',
	'mpkg' => 'application/vnd.apple.installer+xml',
	'mpm' => 'application/vnd.blueice.multipass',
	'mpn' => 'application/vnd.mophun.application',
	'mpp|mpt' => 'application/vnd.ms-project',
	'mpy' => 'application/vnd.ibm.minipay',
	'mqy' => 'application/vnd.mobius.mqy',
	'mrc' => 'application/marc',
	'mscml' => 'application/mediaservercontrol+xml',
	'mseed' => 'application/vnd.fdsn.mseed',
	'mseq' => 'application/vnd.mseq',
	'msf' => 'application/vnd.epson.msf',
	'msh|mesh|silo' => 'model/mesh',
	'msl' => 'application/vnd.mobius.msl',
	'msty' => 'application/vnd.muvee.style',
	'mts' => 'model/vnd.mts',
	'mus' => 'application/vnd.musician',
	'musicxml' => 'application/vnd.recordare.musicxml+xml',
	'mvb|m13|m14' => 'application/x-msmediaview',
	'mwf' => 'application/vnd.mfer',
	'mxf' => 'application/mxf',
	'mxl' => 'application/vnd.recordare.musicxml',
	'mxml|xhvml|xvml|xvm' => 'application/xv+xml',
	'mxs' => 'application/vnd.triscape.mxs',
	'mxu|m4u' => 'video/vnd.mpegurl',
	'n-gage' => 'application/vnd.nokia.n-gage.symbian.install',
	'ncx' => 'application/x-dtbncx+xml',
	'nc|cdf' => 'application/x-netcdf',
	'ngdat' => 'application/vnd.nokia.n-gage.data',
	'nlu' => 'application/vnd.neurolanguage.nlu',
	'nml' => 'application/vnd.enliven',
	'nnd' => 'application/vnd.noblenet-directory',
	'nns' => 'application/vnd.noblenet-sealer',
	'nnw' => 'application/vnd.noblenet-web',
	'npx' => 'image/vnd.net-fpx',
	'nsf' => 'application/vnd.lotus-notes',
	'oa2' => 'application/vnd.fujitsu.oasys2',
	'oa3' => 'application/vnd.fujitsu.oasys3',
	'oas' => 'application/vnd.fujitsu.oasys',
	'obd' => 'application/x-msbinder',
	'oda' => 'application/oda',
	'odb' => 'application/vnd.oasis.opendocument.database',
	'odc' => 'application/vnd.oasis.opendocument.chart',
	'odf' => 'application/vnd.oasis.opendocument.formula',
	'odft' => 'application/vnd.oasis.opendocument.formula-template',
	'odg' => 'application/vnd.oasis.opendocument.graphics',
	'odi' => 'application/vnd.oasis.opendocument.image',
	'odp' => 'application/vnd.oasis.opendocument.presentation',
	'ods' => 'application/vnd.oasis.opendocument.spreadsheet',
	'odt' => 'application/vnd.oasis.opendocument.text',
	'oga|ogg|spx' => 'audio/ogg',
	'ogv' => 'video/ogg',
	'ogx' => 'application/ogg',
	'onetoc|onetoc2|onetmp|onepkg' => 'application/onenote',
	'opf' => 'application/oebps-package+xml',
	'org' => 'application/vnd.lotus-organizer',
	'osf' => 'application/vnd.yamaha.openscoreformat',
	'osfpvg' => 'application/vnd.yamaha.openscoreformat.osfpvg+xml',
	'otc' => 'application/vnd.oasis.opendocument.chart-template',
	'otf' => array( 'application/x-font-otf', 'application/vnd.ms-opentype' ),
	'otg' => 'application/vnd.oasis.opendocument.graphics-template',
	'oth' => 'application/vnd.oasis.opendocument.text-web',
	'oti' => 'application/vnd.oasis.opendocument.image-template',
	'otm' => 'application/vnd.oasis.opendocument.text-master',
	'otp' => 'application/vnd.oasis.opendocument.presentation-template',
	'ots' => 'application/vnd.oasis.opendocument.spreadsheet-template',
	'ott' => 'application/vnd.oasis.opendocument.text-template',
	'oxt' => 'application/vnd.openofficeorg.extension',
	'p10' => 'application/pkcs10',
	'p12|pfx' => 'application/x-pkcs12',
	'p7b|spc' => 'application/x-pkcs7-certificates',
	'p7m|p7c' => 'application/pkcs7-all',
	'p7r' => 'application/x-pkcs7-certreqresp',
	'p7s' => 'application/pkcs7-signature',
	'pbd' => 'application/vnd.powerbuilder6',
	'pbm' => 'image/x-portable-bitmap',
	'pcf' => 'application/x-font-pcf',
	'pcl' => 'application/vnd.hp-pcl',
	'pclxl' => 'application/vnd.hp-pclxl',
	'pcurl' => 'application/vnd.curl.pcurl',
	'pcx' => 'image/x-pcx',
	'pdb|pqa|oprc' => 'application/vnd.palm',
	'pdf' => 'application/pdf',
	'pfa|pfb|pfm|afm' => 'application/x-font-type1',
	'pfr' => 'application/font-tdpfr',
	'pgm' => 'image/x-portable-graymap',
	'pgn' => 'application/x-chess-pgn',
	'pgp' => 'application/pgp-encrypted',
	'pic|pct' => 'image/x-pict',
	'pki' => 'application/pkixcmp',
	'pkipath' => 'application/pkix-pkipath',
	'plb' => 'application/vnd.3gpp.pic-bw-large',
	'plc' => 'application/vnd.mobius.plc',
	'plf' => 'application/vnd.pocketlearn',
	'pls' => 'application/pls+xml',
	'pml' => 'application/vnd.ctc-posml',
	'png' => 'image/png',
	'pnm' => 'image/x-portable-anymap',
	'portpkg' => 'application/vnd.macports.portpkg',
	'potm' => 'application/vnd.ms-powerpoint.template.macroenabled.12',
	'potx' => 'application/vnd.openxmlformats-officedocument.presentationml.template',
	'ppam' => 'application/vnd.ms-powerpoint.addin.macroenabled.12',
	'ppd' => 'application/vnd.cups-ppd',
	'ppm' => 'image/x-portable-pixmap',
	'ppsm' => 'application/vnd.ms-powerpoint.slideshow.macroenabled.12',
	'ppsx' => 'application/vnd.openxmlformats-officedocument.presentationml.slideshow',
	'pptm' => 'application/vnd.ms-powerpoint.presentation.macroenabled.12',
	'pptx' => 'application/vnd.openxmlformats-officedocument.presentationml.presentation',
	'ppt|pps|pot' => 'application/vnd.ms-powerpoint',
	'prc|mobi' => 'application/x-mobipocket-ebook',
	'pre' => 'application/vnd.lotus-freelance',
	'prf' => 'application/pics-rules',
	'psb' => 'application/vnd.3gpp.pic-bw-small',
	'psd' => 'image/vnd.adobe.photoshop',
	'psf' => 'application/x-font-linux-psf',
	'ptid' => 'application/vnd.pvi.ptid1',
	'pub' => 'application/x-mspublisher',
	'pvb' => 'application/vnd.3gpp.pic-bw-var',
	'pwn' => 'application/vnd.3m.post-it-notes',
	'pya' => 'audio/vnd.ms-playready.media.pya',
	'pyv' => 'video/vnd.ms-playready.media.pyv',
	'p|pas' => 'text/x-pascal',
	'qam' => 'application/vnd.epson.quickanime',
	'qbo' => 'application/vnd.intu.qbo',
	'qfx' => 'application/vnd.intu.qfx',
	'qps' => 'application/vnd.publishare-delta-tree',
	'qt|mov' => 'video/quicktime',
	'qxd|qxt|qwd|qwt|qxl|qxb' => 'application/vnd.quark.quarkxpress',
	'ram|ra' => 'audio/x-pn-realaudio',
	'rar' => 'application/x-rar-compressed',
	'ras' => 'image/x-cmu-raster',
	'rcprofile' => 'application/vnd.ipunplugged.rcprofile',
	'rdf' => 'application/rdf+xml',
	'rdz' => 'application/vnd.data-vision.rdz',
	'rep' => 'application/vnd.businessobjects',
	'res' => 'application/x-dtbresource+xml',
	'rgb' => 'image/x-rgb',
	'rif' => 'application/reginfo+xml',
	'rl' => 'application/resource-lists+xml',
	'rlc' => 'image/vnd.fujixerox.edmics-rlc',
	'rld' => 'application/resource-lists-diff+xml',
	'rm' => 'application/vnd.rn-realmedia',
	'rmp' => 'audio/x-pn-realaudio-plugin',
	'rms' => 'application/vnd.jcp.javame.midlet-rms',
	'rnc' => 'application/relax-ng-compact-syntax',
	'rpss' => 'application/vnd.nokia.radio-presets',
	'rpst' => 'application/vnd.nokia.radio-preset',
	'rq' => 'application/sparql-query',
	'rs' => 'application/rls-services+xml',
	'rsd' => 'application/rsd+xml',
	'rss' => 'application/rss+xml',
	'rtf' => 'application/rtf',
	'rtx' => 'text/richtext',
	'saf' => 'application/vnd.yamaha.smaf-audio',
	'sbml' => 'application/sbml+xml',
	'sc' => 'application/vnd.ibm.secure-container',
	'scd' => 'application/x-msschedule',
	'scm' => 'application/vnd.lotus-screencam',
	'scq' => 'application/scvp-cv-request',
	'scs' => 'application/scvp-cv-response',
	'scurl' => 'text/vnd.curl.scurl',
	'sda' => 'application/vnd.stardivision.draw',
	'sdc' => 'application/vnd.stardivision.calc',
	'sdd' => 'application/vnd.stardivision.impress',
	'sdkm|sdkd' => 'application/vnd.solent.sdkm+xml',
	'sdp' => 'application/sdp',
	'sdw' => 'application/vnd.stardivision.writer',
	'see' => 'application/vnd.seemail',
	'seed|dataless' => 'application/vnd.fdsn.seed',
	'sema' => 'application/vnd.sema',
	'semd' => 'application/vnd.semd',
	'semf' => 'application/vnd.semf',
	'ser' => 'application/java-serialized-object',
	'setpay' => 'application/set-payment-initiation',
	'setreg' => 'application/set-registration-initiation',
	'sfd-hdstx' => 'application/vnd.hydrostatix.sof-data',
	'sfs' => 'application/vnd.spotfire.sfs',
	'sgl' => 'application/vnd.stardivision.writer-global',
	'sgml|sgm' => 'text/sgml',
	'sh' => 'application/x-sh',
	'shar' => 'application/x-shar',
	'shf' => 'application/shf+xml',
	'sis|sisx' => 'application/vnd.symbian.install',
	'sit' => 'application/x-stuffit',
	'sitx' => 'application/x-stuffitx',
	'skp|skd|skt|skm' => 'application/vnd.koan',
	'sldm' => 'application/vnd.ms-powerpoint.slide.macroenabled.12',
	'sldx' => 'application/vnd.openxmlformats-officedocument.presentationml.slide',
	'slt' => 'application/vnd.epson.salt',
	'smf' => 'application/vnd.stardivision.math',
	'smi|smil' => 'application/smil+xml',
	'snf' => 'application/x-font-snf',
	'spf' => 'application/vnd.yamaha.smaf-phrase',
	'spl' => 'application/x-futuresplash',
	'spot' => 'text/vnd.in3d.spot',
	'spp' => 'application/scvp-vp-response',
	'spq' => 'application/scvp-vp-request',
	'src' => 'application/x-wais-source',
	'srx' => 'application/sparql-results+xml',
	'sse' => 'application/vnd.kodak-descriptor',
	'ssf' => 'application/vnd.epson.ssf',
	'ssml' => 'application/ssml+xml',
	'stc' => 'application/vnd.sun.xml.calc.template',
	'std' => 'application/vnd.sun.xml.draw.template',
	'stf' => 'application/vnd.wt.stf',
	'sti' => 'application/vnd.sun.xml.impress.template',
	'stk' => 'application/hyperstudio',
	'stl' => 'application/vnd.ms-pki.stl',
	'str' => 'application/vnd.pg.format',
	'stw' => 'application/vnd.sun.xml.writer.template',
	'sus|susp' => 'application/vnd.sus-calendar',
	'sv4cpio' => 'application/x-sv4cpio',
	'sv4crc' => 'application/x-sv4crc',
	'svd' => 'application/vnd.svd',
	'svg|svgz' => 'image/svg+xml',
	'swf' => 'application/x-shockwave-flash',
	'swi' => 'application/vnd.arastra.swi',
	'sxc' => 'application/vnd.sun.xml.calc',
	'sxd' => 'application/vnd.sun.xml.draw',
	'sxg' => 'application/vnd.sun.xml.writer.global',
	'sxi' => 'application/vnd.sun.xml.impress',
	'sxm' => 'application/vnd.sun.xml.math',
	'sxw' => 'application/vnd.sun.xml.writer',
	's|asm' => 'text/x-asm',
	'tao' => 'application/vnd.tao.intent-module-archive',
	'tar' => 'application/x-tar',
	'tcap' => 'application/vnd.3gpp2.tcap',
	'tcl' => 'application/x-tcl',
	'teacher' => 'application/vnd.smart.teacher',
	'tex' => 'application/x-tex',
	'texinfo|texi' => 'application/x-texinfo',
	'tfm' => 'application/x-tex-tfm',
	'tiff|tif' => 'image/tiff',
	'tmo' => 'application/vnd.tmobile-livetv',
	'torrent' => 'application/x-bittorrent',
	'tpl' => 'application/vnd.groove-tool-template',
	'tpt' => 'application/vnd.trid.tpt',
	'tra' => 'application/vnd.trueapp',
	'trm' => 'application/x-msterminal',
	'tsv' => 'text/tab-separated-values',
	'ttf|ttc' => array( 'application/x-font-ttf', 'application/vnd.ms-opentype' ),
	'twd|twds' => 'application/vnd.simtech-mindmapper',
	'txd' => 'application/vnd.genomatix.tuxedo',
	'txf' => 'application/vnd.mobius.txf',
	'txt|text|conf|def|list|log|in' => 'text/plain',
	't|tr|roff|man|me|ms' => 'text/troff',
	'ufd|ufdl' => 'application/vnd.ufdl',
	'umj' => 'application/vnd.umajin',
	'unityweb' => 'application/vnd.unity',
	'uoml' => 'application/vnd.uoml+xml',
	'uri|uris|urls' => 'text/uri-list',
	'ustar' => 'application/x-ustar',
	'utz' => 'application/vnd.uiq.theme',
	'uu' => 'text/x-uuencode',
	'vcd' => 'application/x-cdlink',
	'vcf' => 'text/x-vcard',
	'vcg' => 'application/vnd.groove-vcard',
	'vcs' => 'text/x-vcalendar',
	'vcx' => 'application/vnd.vcx',
	'vis' => 'application/vnd.visionary',
	'viv' => 'video/vnd.vivo',
	'vor' => 'application/vnd.stardivision.writer',
	'vsd|vst|vss|vsw' => 'application/vnd.visio',
	'vsf' => 'application/vnd.vsf',
	'vtu' => 'model/vnd.vtu',
	'vxml' => 'application/voicexml+xml',
	'wad' => 'application/x-doom',
	'wav' => 'audio/x-wav',
	'wax' => 'audio/x-ms-wax',
	'wbmp' => 'image/vnd.wap.wbmp',
	'wbs' => 'application/vnd.criticaltools.wbs+xml',
	'wbxml' => 'application/vnd.wap.wbxml',
	'webm' => 'video/webm',
	'webp' => 'image/webp',
	'wm' => 'video/x-ms-wm',
	'wma' => 'audio/x-ms-wma',
	'wmd' => 'application/x-ms-wmd',
	'wmf' => 'application/x-msmetafile',
	'wml' => 'text/vnd.wap.wml',
	'wmlc' => 'application/vnd.wap.wmlc',
	'wmls' => 'text/vnd.wap.wmlscript',
	'wmlsc' => 'application/vnd.wap.wmlscriptc',
	'wmv' => 'video/x-ms-wmv',
	'wmx' => 'video/x-ms-wmx',
	'wmz' => 'application/x-ms-wmz',
	'wpd' => 'application/vnd.wordperfect',
	'wpl' => 'application/vnd.ms-wpl',
	'wps|wks|wcm|wdb' => 'application/vnd.ms-works',
	'wqd' => 'application/vnd.wqd',
	'wri' => 'application/x-mswrite',
	'wrl|vrml' => 'model/vrml',
	'wsdl' => 'application/wsdl+xml',
	'wspolicy' => 'application/wspolicy+xml',
	'wtb' => 'application/vnd.webturbo',
	'wvx' => 'video/x-ms-wvx',
	'x3d' => 'application/vnd.hzn-3d-crossword',
	'xap' => 'application/x-silverlight-app',
	'xar' => 'application/vnd.xara',
	'xbap' => 'application/x-ms-xbap',
	'xbd' => 'application/vnd.fujixerox.docuworks.binder',
	'xbm' => 'image/x-xbitmap',
	'xdm' => 'application/vnd.syncml.dm+xml',
	'xdp' => 'application/vnd.adobe.xdp+xml',
	'xdw' => 'application/vnd.fujixerox.docuworks',
	'xenc' => 'application/xenc+xml',
	'xer' => 'application/patch-ops-error+xml',
	'xfdf' => 'application/vnd.adobe.xfdf',
	'xfdl' => 'application/vnd.xfdl',
	'xhtml|xht' => 'application/xhtml+xml',
	'xif' => 'image/vnd.xiff',
	'xlam' => 'application/vnd.ms-excel.addin.macroenabled.12',
	'xlsb' => 'application/vnd.ms-excel.sheet.binary.macroenabled.12',
	'xlsm' => 'application/vnd.ms-excel.sheet.macroenabled.12',
	'xlsx' => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
	'xls|xlm|xla|xlc|xlt|xlw' => 'application/vnd.ms-excel',
	'xltm' => 'application/vnd.ms-excel.template.macroenabled.12',
	'xltx' => 'application/vnd.openxmlformats-officedocument.spreadsheetml.template',
	'xml|xsl' => 'application/xml',
	'xo' => 'application/vnd.olpc-sugar',
	'xop' => 'application/xop+xml',
	'xpi' => 'application/x-xpinstall',
	'xpm' => 'image/x-xpixmap',
	'xpr' => 'application/vnd.is-xpr',
	'xps' => 'application/vnd.ms-xpsdocument',
	'xpw|xpx' => 'application/vnd.intercon.formnet',
	'xslt' => 'application/xslt+xml',
	'xsm' => 'application/vnd.syncml+xml',
	'xspf' => 'application/xspf+xml',
	'xul' => 'application/vnd.mozilla.xul+xml',
	'xwd' => 'image/x-xwindowdump',
	'xyz' => 'chemical/x-xyz',
	'zaz' => 'application/vnd.zzazz.deck+xml',
	'zip' => 'application/zip',
	'zir|zirz' => 'application/vnd.zul',
	'zmm' => 'application/vnd.handheld-entertainment+xml'
);
